;
; DLX Emulation Control File
;
; This file is designed to provide emulation of DLX chat functionality.
; It does not necessarily provide all the features of DLX's chat, but it
; does provide all the common functionality in as close a presentation as
; possible.
;
; This control file does require DLX style entry mode, so use a /E:3
; in the Opt Data of UltraChat when you invoke this control file.
;
; ===================================================================
; NOTE: The TBBS COUNTRY field from the userlog is assumed to be
;      where a person's "status" for WHO commands is stored.  A QAL
;      needs to be set up to make this a true statement!  This field
;      is also displayed when two users get into private chat.  Of
;      course all of this is configurable, but this file uses that
;      field as a default.
; ===================================================================
;
;
;
;
; ----- HEADER ------------------------------------------------------
;
; ** CHANGE FOR YOUR OWN NEEDS **
;
SYSTEM_NAME_TEXT "Test Ultra-Chat System"
SYSTEM_ID_TEXT "UltraTst"
SYSOP_NAME_TEXT "The SysOp"
UCHAT_DIR SLASHT
;
; ----- STYLE AND GENERAL -------------------------------------------
;
MIN_CHANNEL_NUM 1
MAX_CHANNEL_NUM 40
SHORTCUT_KEY /
LIST_ME_SWITCH 1
EXIT_CHAT_KEY ^C
NAME_NUM_PARSER
;
; ----- DLX STYLE COMMANDS ------------------------------------------
;
; User browse
;
WHO#10_CMD      /B          MODE=ABCD           ;/B
   WHO#10_NAMEPMT "Which User ID? => "
   WHO#10_NORMAL  "^M%UHANDLE:C%, from %ULOCATION:C%, last logged on %ULASTON%^M%UFLAGS%^@   %U3LINEBIO%^M^M"
   WHO#10_ERROR   "^MThere is no such User ID on this system.^M"
;
; Private message sending
;
PRIVATE#01_CMD  /P          MODE=BCD            ;/P
   PRIVATE#01_REMOTE  "^G<%RHANDLE:C% %RLINE%> /p%LINE% %RMSG%^M"
   PRIVATE#01_NAMEPMT "Which User ID? => "
   PRIVATE#01_MSGPMT  "Input up to 2 lines of text to send to %RHANDLE:C% %RLINE%:^M^M"
   PRIVATE#01_NOCHAT  "^MSorry, but that user asked not to be disturbed!^M"
   PRIVATE#01_ERROR   "^MThat user cannot be interrupted right now.^M^M"
;
; Exit chat
;
EXIT#01_CMD     /Q          MODE=BCD  EXACT     ;/Q
;
; General who command
;
WHO#01_CMD      /W          MODE=ABCD EXACT     ;/W
   WHO#01_HEADER "Users Currently Online^M
         +       Line    Caller                    From                Info    Status^M
         +        --------------------------------------------------------------------^M"
   WHO#01_NORMAL "Line %RLINE:+02% %RHANDLE:25C% %RLOCATION:19C% %RCOUNTRY:7% %RANNOUNCE%^M"
   WHO#01_IDLE   "Line  %RLINE:+02% Ready^M"
   WHO#01_TOTAL  "^M^@ %LISTED% of %LASTLINE% lines in use.^M^M"
;
; Remember a user
;
INTERACT#02_CMD /X0         MODE=BCD            ;/X0
;
; Ignore a user
;
INTERACT#01_CMD /X          MODE=BCD            ;/X
;
; Help file display
;
HELP#01_CMD     /HELP       MODE=BCD  EXACT     ;/HELP
HELP#01_CMD     /?          MODE=BCD  EXACT     ;/?
   HELP#01_FILE  DLXHELP.TXT
   HELP#01_ERROR "Help file not found!^M"
;
; Ask a user to one on one chat
;
CHAT#01_CMD     C           MODE=A              ;chat with user
   CHAT#01_PROMPT  "Which User ID? => "
   CHAT#01_REMOTE  "^G%RHANDLE:C%: (psst!) I want to chat.  Press C from the menu to go to chat^M"
   CHAT#01_CONFIRM "%RHANDLE:C% %RLINE% has been notified that you wish to chat.^M"
   CHAT#01_NOCHAT  "^MSorry, but that user asked not to be disturbed!^M"
   CHAT#01_SELF    "Sorry, but you can't do that to yourself!^M"
;
; Invisible command
;
ON#01_CMD       I           MODE=A   EXACT	;make invisible
;
; Visible command
;
OFF#01_CMD      V           MODE=A   EXACT      ;make visible
;
; No chat on
;
ON#02_CMD       NC          MODE=A   EXACT      ;make nochat
;
; No chat off (chattable)
;
OFF#02_CMD      OC          MODE=A   EXACT      ;make okchat
;
; No logon announcements
;
ON#03_CMD       N           MODE=A   EXACT      ;make nologon
;
; Announce logons
;
OFF#03_CMD      L           MODE=A   EXACT      ;make logon
;
; Secondary help file display
;
HELP#02_CMD     J           MODE=A   EXACT      ;J
   HELP#02_FILE  DLXINFO.TXT
   HELP#02_ERROR =HELP#01_ERROR
;
; Change announce string
;
OPTIONS#02_CMD  A           MODE=A              ;change announce
;
; Channel change elements
;
CHANNEL#01_CHANPMT "-> Which channel do you want (%MINCHANNEL%-%MAXCHANNEL%)?^M=> "
CHANNEL#01_BADNUM  "Channel number out of range %MINCHANNEL%-%MAXCHANNEL%.^MTry again!^M^M"
CHANNEL#01_NOTNUM  "Invalid number entered.^MTry again!^M^M"
CHANNEL#01_CONFIRM "^M* * * * * * * * * * * * * * * * * * *^M
      +        * Entering Open Forum - Channel %CHANNEL:2% *^M
      +        * * * * * * * * * * * * * * * * * * *^M
      +        ^M
      +        Just type a line and everyone will see it.^M
      +        /Q to Quit^M
      +        /? for Help^M^M"
;
; Three-line bio commands
;
BIO#01_PROMPT "Before you proceed, you MUST fill out the three line bio.  The
      +    | more interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines) of
      +    | text to use.  Do not press <Enter> until you are done!  Word
      +    | wrapping happens automatically.  Start typing: ^M^M"

BIO#02_PROMPT "You are about to change your three line bio.  The more 
      +    | interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines)
      +    | of text to use.  Do not press <Enter> until you are done!
      +    |  Word wrapping happens automatically.  Start typing: ^M^M"

BIO#02_YN "Are you sure you want to change your three line bio (Y/N)? "
;
; The next string gets displayed in a WO display if the user has used
; the /N command to get into NOCHAT mode.
;
USER#04_TEXT "I don't want to chat now"
CHAT#02_TEXT " %RLINE:+02%  %RHANDLE:20C% (%RCOUNTRY%)^M"
;
; Sent for a public message
;
CHAT#01_TEXT "<%RHANDLE:C% %RLINE%> %RMSG%^M"
;
; Public chat message prefix
;
CHAT#23_TEXT "^M"
;
; User waiting for to chat one on one logged off
;
CHAT#24_TEXT "^MThe user you are waiting for is no longer logged on, exiting wait mode.^M"
;
; Error strings
;
ERROR#01_TEXT "Unrecognized command.  Type /? for Help.^M"
ERROR#02_TEXT "That User ID is not currently logged on.^M"
ERROR#03_TEXT "That User ID refers to multiple users.^M"
ERROR#04_TEXT "^MW commands are not allowed while you are invisible.^M^M"
ERROR#05_TEXT "^MSorry, but that user asked not to be disturbed!^M"
ERROR#06_TEXT "Sorry, but you can't do that to yourself!^M"
ERROR#07_TEXT "That User ID can refer to multiple users, if you wish to send
      +    | to a specific user, end the User ID with a : for example 'SYSOP:' or
      +    | '%HANDLE:C%:'^M"
;
; Chat entry header when people are waiting
;
CHAT#03_TEXT "The following user(s) are waiting to chat with you:^M^M"
;
; Prompt when only one user is waiting to chat
;
CHAT#04_TEXT "Would you like to go into private chat with this user (Y/n)? "
;
; Prompt when several people are waiting to chat
;
CHAT#05_TEXT "Enter the line number of the person that you want to chat with,
      +    | or C to enter chat with someone else: "
;
; Prompt asking if a user wants to wait for a chat to start
;
CHAT#07_TEXT "^MDo you wish to wait for the other user (Y/n)? "
;
; Prompt telling the user they are waiting
;
CHAT#08_TEXT "^MYou are now waiting for the other user.  A period will appear
      +      | every 5 seconds while you wait.  Press the <Enter> key at any
      +      | time to stop waiting for the other user.^M^M"
;
; Tells the user that the other person in the private chat has left
;
CHAT#09_TEXT "^M* * * * * * * * * * * * * * * * * * * * *^M
      +        *           Exiting Chat Mode           *^M
      +        *   (due to Ctrl-C or getting BUMPed)   *^M
      +        *   Press Enter to see the next Menu    *^M
      +        * * * * * * * * * * * * * * * * * * * * *^M^M"

;
; Tells the user they are in private chat now
;
CHAT#10_TEXT "^M* * * * * * * * * * * * * * * * * * *^M
      +        *        Entering Chat Mode         *^M
      +        * * * * * * * * * * * * * * * * * * *^M^M
      +        Chat from: %HANDLE:C% %LINE% (%COUNTRY%)^M
      +        Chat to: %RHANDLE:C% %RLINE% (%RCOUNTRY%)^M^M
      +        Type CTRL-C TO EXIT^M^M"
;
; Tells the user they are in public chat
;
CHAT#11_TEXT "^M* * * * * * * * * * * * * * * * * * *^M
      +        * Entering Open Forum - Channel %CHANNEL:2% *^M
      +        * * * * * * * * * * * * * * * * * * *^M
      +        ^M
      +        Just type a line and everyone will see it.^M
      +        /Q to Quit^M
      +        /? for Help^M^M"
;
; Sent when a user sends a message in a public conference
;
CHAT#16_TEXT "<%HANDLE:C% %LINE%> %TYPED%^M"
CHAT#17_TEXT =CHAT#16_TEXT
CHAT#18_TEXT =CHAT#09_TEXT
;
; Wait for keypress
;
MISC#02_TEXT "Press any key to continue..."
;
; User just logged in
;
MISC#03_TEXT "[%RHANDLE:C% %RLINE% logged in]^M"
;
; Kill line command acknowledgement
;
MISC#08_TEXT "^^^M"
;
; Banner displayed on entry to chat
;
MISC#09_TEXT "^[[0;1;37mWelcome to %VERSION% in DLX emulation mode!^M^M"
